<?php
/*--------------------------------------------------------------
   Title.php 2021-08-01
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\DashboardWidget\Model\ValueObjects;

use JsonSerializable;

class Title implements JsonSerializable
{
    /**
     * @var string
     */
    private $title;
    
    
    /**
     * Constructor.
     */
    public function __construct(string $title)
    {
        $this->title = $title;
    }
    
    
    /**
     * Return title.
     */
    public function value(): string
    {
        return $this->title;
    }
    
    
    /**
     * @inheritDoc
     */
    public function jsonSerialize(): string
    {
        return $this->value();
    }
}